﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Data;
using System.Data.SqlClient;
using AZVIC.Ei8htPOS.Entities;
using AZVIC.Ei8htPOS.Utilities;

namespace AZVIC.Ei8htPOS.DAL
{
    public class ProductsXMeasurementsDB
    {
        public static ProductsXMeasurements GetItem(Guid ProductXMeasurementID,Guid ProductID)
        {
            List<SqlParameter> parameters = new List<SqlParameter>();
            parameters.Add(new SqlParameter("@ProductsXMeasurementsID", ((ProductXMeasurementID != Guid.Empty && ProductXMeasurementID != null) ? ProductXMeasurementID : (object)DBNull.Value)));
            parameters.Add(new SqlParameter("@ProductID", ((ProductID != Guid.Empty && ProductID != null) ? ProductID : (object)DBNull.Value)));


            return SQLHelper.RetrieveObject<ProductsXMeasurements>("spGetProductsXMeasurements", parameters);
        }

        public static List<ProductsXMeasurements> GetList(Guid ProductXMeasurementID, Guid ProductID)
        {
            List<SqlParameter> parameters = new List<SqlParameter>();
            parameters.Add(new SqlParameter("@ProductsXMeasurementsID", ((ProductXMeasurementID != Guid.Empty && ProductXMeasurementID != null) ? ProductXMeasurementID : (object)DBNull.Value)));
            parameters.Add(new SqlParameter("@ProductID", ((ProductID != Guid.Empty && ProductID != null) ? ProductID : (object)DBNull.Value)));


            return SQLHelper.RetrieveList<ProductsXMeasurements>("spGetProductsXMeasurements", parameters);
        }

        public static void Save(ProductsXMeasurements ProductSizes)
        {
            List<SqlParameter> parameters = new List<SqlParameter>();
            if (ProductSizes.ProductsXMeasurementID == Guid.Empty)
            {
                ProductSizes.ProductsXMeasurementID = Guid.NewGuid();
            }
            parameters.Add(new SqlParameter("@ProductsXMeasurementID", (ProductSizes.ProductsXMeasurementID != null && ProductSizes.ProductsXMeasurementID != Guid.Empty) ? ProductSizes.ProductsXMeasurementID : (object)DBNull.Value));
            parameters.Add(new SqlParameter("@BaseID", (ProductSizes.BaseSizeID!= null && ProductSizes.BaseSizeID != Guid.Empty) ? ProductSizes.BaseSizeID: (object)DBNull.Value));
            parameters.Add(new SqlParameter("@TargetSizeID", (ProductSizes.TargetSizeID != null && ProductSizes.TargetSizeID != Guid.Empty) ? ProductSizes.TargetSizeID : (object)DBNull.Value));
            parameters.Add(new SqlParameter("@ProductID", (ProductSizes.ProductID != null && ProductSizes.ProductID != Guid.Empty) ? ProductSizes.ProductID : (object)DBNull.Value));
            parameters.Add(new SqlParameter("@TargetConversion", (ProductSizes.TargetConversion)));
            parameters.Add(new SqlParameter("@IsActive", (ProductSizes.IsActive)));
            parameters.Add(new SqlParameter("@CreatedBy", (ProductSizes.CreatedBy != null && ProductSizes.CreatedBy != Guid.Empty) ? ProductSizes.CreatedBy : (object)DBNull.Value));
            parameters.Add(new SqlParameter("@TargetSizeName", ((!string.IsNullOrEmpty(ProductSizes.TargetSizeName)) ? ProductSizes.TargetSizeName : (object)DBNull.Value)));


            SQLHelper.ExecuteQuery("spAddOrUpdateProductsXMeasurements", parameters);
        }

        //public static void Delete(Guid TableID)
        //{
        //    List<SqlParameter> parameters = new List<SqlParameter>();
        //    parameters.Add(new SqlParameter("@TableID", ((TableID != Guid.Empty && TableID != null) ? TableID : (object)DBNull.Value)));

        //    SQLHelper.ExecuteQuery("spRemoveLayout", parameters);
        //}

    }
}

